<?php
$currentPage = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
<link rel="stylesheet" href="assests/style.css">
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
   </head>
<body>

 <!-- HEADER -->
  <header>
    <div class="navbar">
      <a class="logo" href="./index.php"><img src="assests/images/headlogo.png" alt="First Choice"></a>
      <button class="nav-toggle" aria-label="Toggle navigation" aria-expanded="false">
        <span></span>
      </button>
      <nav class="nav">
        <ul>
        <li><a href="./index.php" class="<?= $currentPage === 'index.php' ? 'active' : '' ?>">Home</a></li>
          <li><a href="./aboutus.php" class="<?= $currentPage === 'aboutus.php' ? 'active' : '' ?>">About Us</a></li>
          <li><a href="./certification.php" class="<?= $currentPage === 'certification.php' ? 'active' : '' ?>">Certification</a></li>
          <li><a href="./team.php" class="<?= $currentPage === 'team.php' ? 'active' : '' ?>">Team</a></li>
          <li><a href="./projects.php" class="<?= $currentPage === 'projects.php' ? 'active' : '' ?>">Projects</a></li>
                    <li><a href="./services.php" class="<?= $currentPage === 'services.php' ? 'active' : '' ?>">Services</a></li>
          <li><a href="./contactus.php" class="<?= $currentPage === 'contactus.php' ? 'active' : '' ?>">Contact Us</a></li>
        </ul>
      </nav>
    </div>
  </header>
  <!-- HERO -->
  <section class="hero">
    <div class="hero-inner container">
      <div class="hero-content">
        <span class="hero-kicker">About First Choice</span>
        <h1>Built on Integrity. Proven on Site.</h1>
        <p>Since 2004, we have delivered civil construction, maintenance, interiors, steel fabrication, MEP works, and custom joinery across the UAE and Oman with disciplined execution and consistent quality.</p>
        <div class="hero-actions">
          <a class="hero-cta" href="./contactus.php">Talk to Our Team</a>
          <a class="hero-ghost" href="./projects.php">View Projects</a>
        </div>
        <div class="hero-meta">
          <div class="hero-stat">
            <strong>20+ Years</strong>
            <span>Regional delivery since August 2004</span>
          </div>
          <div class="hero-stat">
            <strong>500+ Projects</strong>
            <span>Industrial, commercial, and residential</span>
          </div>
          <div class="hero-stat">
            <strong>ISO 18001</strong>
            <span>Safety-first operations and compliance</span>
          </div>
        </div>
      </div>
      <div class="hero-card">
        <h4>What Sets Us Apart</h4>
        <ul>
          <li><i class="fa-solid fa-check"></i> Value engineering and disciplined project control</li>
          <li><i class="fa-solid fa-check"></i> Skilled teams across civil, decor, MEP, and steel</li>
          <li><i class="fa-solid fa-check"></i> Transparent timelines with reliable execution</li>
          <li><i class="fa-solid fa-check"></i> Client-focused delivery and long-term trust</li>
        </ul>
      </div>
    </div>
  </section>

  

<!-- ABOUT US -->
<section class="section-light">
  <div class="container about-layout">
    
   
    
    <!-- TEXT CONTENT -->
    <div class="about-text-col">
      <div class="section-title" style="text-align:left; margin-bottom:20px;"><h2>About Us</h2></div>
      <p style="font-size:16px; color:#555; margin-bottom:20px; line-height:1.8;">
       First Choice is a group of companies providing high-quality services to industrial, commercial, and residential sectors, utilizing the latest value engineering processes.

Established in August 2004 in Abu Dhabi, UAE, First Choice has expanded its operations to Oman to meet the growing demand for professional construction and interior solutions.
<br>
<br>
<span class="about-highlight">Our Core Principles</span>
<br>
<span class="about-highlight">Integrity:</span> <br>
We act with honesty, consistency, and fairness in all our dealings, communicating openly and directly.
<br><br>
<span class="about-highlight">Customer Satisfaction:</span> <br>
We aim to exceed client expectations by delivering high-quality services with dedication and care.
<br><br>

<span class="about-highlight">Commitment to Innovation:</span> <br>
Continuous learning and adoption of state-of-the-art technologies enable us to enhance operational efficiency and deliver superior solutions.
<br><br>

<span class="about-highlight">Safety:</span> <br>
Our employees are our most valuable asset. We provide safe and sustainable working conditions, following international standards (ISO 18001:2007).
<br><br>

<span class="about-highlight">Teamwork:</span> <br>
We attract and develop top talent, fostering an environment where individual growth drives overall company growth. </p>

  
 <!-- HIGHLIGHTS -->
      <div class="highlights-grid">
        <div class="highlight-card">
          <h3 style="color:#0f2a44;">20+</h3>
          <p>Years Experience</p>
        </div>
        <div class="highlight-card">
          <h3 style="color:#0f2a44;">500+</h3>
          <p>Projects Completed</p>
        </div>
        <div class="highlight-card">
          <h3 style="color:#0f2a44;">100%</h3>
          <p>Client Satisfaction</p>
        </div>
        <div class="highlight-card">
          <h3 style="color:#0f2a44;">100+</h3>
          <p>Expert Professionals</p>
        </div>
      </div>


     
    </div>
    
  </div>
</section>



<!-- COMPANY PDFS -->
<section class="pdf-section">
  <div class="container">
    <div class="section-title" style="margin-bottom:30px;">
      <h2>Company Documents</h2>
      <p>
        View our official company profile and related documentation in your browser.
      </p>
    </div>

    <div class="pdf-grid">
      <a class="pdf-card" href="assests/images/first_choice_company_profile.pdf" target="_blank" rel="noopener">
        <div class="pdf-icon"><i class="fa-solid fa-file-pdf"></i></div>
        <div>
          <h4>First Choice Company Profile</h4>
          <p>Open PDF in a new tab</p>
        </div>
      </a>

      <a class="pdf-card" href="assests/images/facapc.pdf" target="_blank" rel="noopener">
        <div class="pdf-icon"><i class="fa-solid fa-file-pdf"></i></div>
        <div>
          <h4>FCAPC Document</h4>
          <p>Open PDF in a new tab</p>
        </div>
      </a>
    </div>
  </div>
</section>



 <!-- FOOTER -->
  <footer>
    <p>
      First Choice Group of Companies <br>
      First Choice Real General Contracting and Maintenance LLC OPC (FCRGC) <br>
      First Choice Automotive Parts Cars Sole Proprietorship LLC (FCAPC) <br>
      <br>
      © 2024-2025
    </p>
  </footer>




<script src="./script.js"></script>
  <script src="assests/site.js"></script>
</body>
</html>
