<?php
include "includes/db.php";
include "includes/auth.php";
include "includes/header.php";
include "includes/sidebar.php";

// Sidebar Toggle Button for Mobile
echo '<button class="sidebar-toggle"><i class="fa fa-bars"></i></button>';

// Get counts from database
$servicesCount = $conn->query("SELECT COUNT(*) as count FROM services")->fetch_assoc()['count'];
$projectsCount = $conn->query("SELECT COUNT(*) as count FROM projects")->fetch_assoc()['count'];
$certCount = $conn->query("SELECT COUNT(*) as count FROM certifications")->fetch_assoc()['count'];
$teamCount = $conn->query("SELECT COUNT(*) as count FROM team")->fetch_assoc()['count'];
$messagesCount = $conn->query("SELECT COUNT(*) as count FROM messages")->fetch_assoc()['count'];
$totalMessages = $conn->query("SELECT COUNT(*) as count FROM messages")->fetch_assoc()['count'];
?>

<style>
.dashboard-title{
    font-weight:600 !important;
    color:#0f2a44 !important;
}
.stat-card{
    border:none !important;
    border-radius:15px !important;
    transition:0.3s !important;
}
.stat-card div > div {
    display:flex !important;
    flex-direction:column !important;
}
.stat-card h6 {
    display:block !important;
    color:#fff !important;
    font-weight:700 !important;
    font-size:14px !important;
    margin:0 !important;
    padding:0 !important;
    margin-bottom:8px !important;
    letter-spacing:0.5px !important;
    line-height:1.2 !important;
    visibility:visible !important;
}
.stat-card h3 {
    display:block !important;
    color:#fff !important;
    font-weight:800 !important;
    font-size:32px !important;
    margin:0 !important;
    padding:0 !important;
    line-height:1 !important;
    visibility:visible !important;
}
.bg-gradient-primary {
    background:linear-gradient(45deg,#4e73df,#224abe) !important;
}
.bg-gradient-primary h6 {
    color:#ffffff !important;
    font-weight:700 !important;
}
.bg-gradient-primary h3 {
    color:#ffffff !important;
}
.bg-gradient-success {
    background:linear-gradient(45deg,#1cc88a,#13855c) !important;
}
.bg-gradient-success h6 {
    color:#ffffff !important;
    font-weight:700 !important;
}
.bg-gradient-success h3 {
    color:#ffffff !important;
}
.bg-gradient-warning {
    background:linear-gradient(45deg,#f6c23e,#dda20a) !important;
}
.bg-gradient-warning h6 {
    color:#2c3e50 !important;
    font-weight:700 !important;
}
.bg-gradient-warning h3 {
    color:#2c3e50 !important;
}
.bg-gradient-danger {
    background:linear-gradient(45deg,#e74a3b,#be2617) !important;
}
.bg-gradient-danger h6 {
    color:#ffffff !important;
    font-weight:700 !important;
}
.bg-gradient-danger h3 {
    color:#ffffff !important;
}
.bg-gradient-info {
    background:linear-gradient(45deg,#17a2b8,#138496) !important;
}
.bg-gradient-info h6 {
    color:#ffffff !important;
    font-weight:700 !important;
}
.bg-gradient-info h3 {
    color:#ffffff !important;
}
.stat-card:hover {
    transform:translateY(-5px) !important;
    box-shadow: 0 8px 20px rgba(0,0,0,0.15) !important;
}
.icon-circle{
    width:50px !important;
    height:50px !important;
    border-radius:50% !important;
    background:rgba(255,255,255,0.2) !important;
    display:flex !important;
    align-items:center !important;
    justify-content:center !important;
    font-size:22px !important;
    color:#fff !important;
}
.quick-card{
    border-radius:15px !important;
    background:#fff !important;
    border:1px solid #e0e0e0 !important;
    color:#2c3e50 !important;
}
.quick-card h5 {
    color:#0f2a44 !important;
    font-weight:700 !important;
    margin-bottom:20px !important;
}
.quick-card .list-group-item {
    border:none !important;
    padding:12px 0 !important;
    background:transparent !important;
    color:#333 !important;
    font-size:14px !important;
}
.quick-card .list-group-item strong {
    color:#667eea !important;
    font-weight:700 !important;
}
</style>

<div class="container-fluid">

    <!-- PAGE HEADER -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="dashboard-title">Dashboard</h3>
        <span class="text-muted">Welcome, <?php echo htmlspecialchars($_SESSION['admin_name']); ?></span>
    </div>

    <!-- STAT CARDS -->
    <div class="row g-4 mb-4">
        <div class="col-md-3">
            <a href="/firstchoice_admin/admin/pages/services/services.php" style="text-decoration: none;">
                <div class="card stat-card bg-gradient-primary shadow p-4">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6>Total Services</h6>
                            <h3><?= $servicesCount ?></h3>
                        </div>
                        <div class="icon-circle">
                            <i class="fa fa-cogs"></i>
                        </div>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md-3">
            <a href="/firstchoice_admin/admin/pages/projects/projects.php" style="text-decoration: none;">
                <div class="card stat-card bg-gradient-success shadow p-4">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6>Total Projects</h6>
                            <h3><?= $projectsCount ?></h3>
                        </div>
                        <div class="icon-circle">
                            <i class="fa fa-briefcase"></i>
                        </div>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md-3">
            <a href="/firstchoice_admin/admin/pages/certification/certification.php" style="text-decoration: none;">
                <div class="card stat-card bg-gradient-warning shadow p-4">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6>Certifications</h6>
                            <h3><?= $certCount ?></h3>
                        </div>
                        <div class="icon-circle">
                            <i class="fa fa-certificate"></i>
                        </div>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md-3">
            <a href="/firstchoice_admin/admin/pages/team/team.php" style="text-decoration: none;">
                <div class="card stat-card bg-gradient-info shadow p-4">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6>Team Members</h6>
                            <h3><?= $teamCount ?></h3>
                        </div>
                        <div class="icon-circle">
                            <i class="fa fa-users"></i>
                        </div>
                    </div>
                </div>
            </a>
        </div>

        <div class="col-md-3">
            <a href="/firstchoice_admin/admin/pages/messages.php" style="text-decoration: none;">
                <div class="card stat-card bg-gradient-danger shadow p-4">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6>New Messages</h6>
                            <h3><?= $messagesCount ?></h3>
                        </div>
                        <div class="icon-circle">
                            <i class="fa fa-envelope"></i>
                        </div>
                    </div>
                </div>
            </a>
        </div>
    </div>

    <!-- QUICK ACTIONS + INFO -->
    <div class="row g-4">

        <div class="col-md-8">
            <div class="card quick-card shadow p-4">
                <h5 class="mb-3">Quick Actions</h5>
                <div class="row g-3">
                    <div class="col-md-4">
                        <a href="/firstchoice_admin/admin/pages/services/add_services.php" class="btn btn-primary w-100">
                            <i class="fa fa-plus"></i> Add Service
                        </a>
                    </div>
                    <div class="col-md-4">
                        <a href="/firstchoice_admin/admin/pages/projects/add_project.php" class="btn btn-success w-100">
                            <i class="fa fa-plus"></i> Add Project
                        </a>
                    </div>
                    <div class="col-md-4">
                        <a href="/firstchoice_admin/admin/pages/certification/add_certification.php" class="btn btn-warning w-100 text-white">
                            <i class="fa fa-plus"></i> Add Certificate
                        </a>
                    </div>
                    <div class="col-md-4">
                        <a href="/firstchoice_admin/admin/pages/team/add_team.php" class="btn btn-info w-100 text-white">
                            <i class="fa fa-plus"></i> Add Team Member
                        </a>
                    </div>
                    <div class="col-md-4">
                        <a href="/firstchoice_admin/admin/pages/messages.php" class="btn btn-danger w-100">
                            <i class="fa fa-envelope"></i> View Messages
                        </a>
                    </div>
                    <div class="col-md-4">
                        <a href="/firstchoice_admin/admin/pages/services/services.php" class="btn btn-dark w-100">
                            <i class="fa fa-list"></i> Manage Services
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card quick-card shadow p-4">
                <h5 class="mb-3">System Info</h5>
                <ul class="list-group list-group-flush">
                    <li class="list-group-item">Admin: <strong><?php echo htmlspecialchars($_SESSION['admin_name']); ?></strong></li>
                    <li class="list-group-item">Role: Super Admin</li>
                    <li class="list-group-item">Status: <span class="badge bg-success">Active</span></li>
                    <li class="list-group-item">Total Messages: <?= $totalMessages ?></li>
                </ul>
            </div>
        </div>

    </div>

</div>

<?php include "includes/footer.php"; ?>
