<?php 
include "../../includes/db.php";
include "../../includes/auth.php";

if ($_POST) {
    $title = mysqli_real_escape_string($conn, $_POST['title']);
    $certType = $_POST['cert_type'] ?? 'real';
    $certType = $certType === 'automotive' ? 'automotive' : 'real';
    $tableName = $certType === 'automotive' ? 'automotive_certifications' : 'certifications';

    $hasImage = false;
    $imageCol = $conn->query("SHOW COLUMNS FROM $tableName LIKE 'image'");
    if ($imageCol && $imageCol->num_rows > 0) {
        $hasImage = true;
    } else {
        $conn->query("ALTER TABLE $tableName ADD COLUMN image VARCHAR(255) NULL AFTER title");
        $imageCol = $conn->query("SHOW COLUMNS FROM $tableName LIKE 'image'");
        if ($imageCol && $imageCol->num_rows > 0) {
            $hasImage = true;
        }
    }

    $imageRel = '';
    if (!empty($_FILES['image']['name'] ?? '')) {
        $target_dir = "../../../files/";
        if (!is_dir($target_dir)) {
            mkdir($target_dir, 0755, true);
        }
        $fileName = time() . "_" . basename($_FILES["image"]["name"]);
        $target_file = $target_dir . $fileName;
        move_uploaded_file($_FILES["image"]["tmp_name"], $target_file);
        $imageRel = $fileName;
    }

    if ($hasImage) {
        $conn->query("INSERT INTO $tableName (title, image) VALUES ('$title', '$imageRel')");
    } else {
        $conn->query("INSERT INTO $tableName (title) VALUES ('$title')");
    }

    header("Location: certification.php");
    exit;
}

include "../../includes/header.php"; 
include "../../includes/sidebar.php"; 
?>

<style>
.form-container {
    max-width: 700px;
    margin: 0 auto;
}

.form-card {
    background: white;
    border-radius: 12px;
    padding: 30px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.08);
}

.form-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 30px;
    padding-bottom: 15px;
    border-bottom: 2px solid #f0f0f0;
}

.page-title {
    color: #0f2a44;
    font-weight: 600;
    font-size: 24px;
    margin: 0;
}

.form-group {
    margin-bottom: 20px;
}

.form-label {
    display: block;
    margin-bottom: 8px;
    font-weight: 500;
    color: #333;
    font-size: 14px;
}

.form-control {
    width: 100%;
    padding: 10px 15px;
    border: 1px solid #ddd;
    border-radius: 6px;
    font-size: 14px;
    transition: 0.3s;
}

.form-control:focus {
    outline: none;
    border-color: #667eea;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
}

.btn-group {
    display: flex;
    gap: 10px;
    margin-top: 30px;
    padding-top: 15px;
    border-top: 1px solid #f0f0f0;
}

.btn-submit {
    background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 10px 30px;
    border: none;
    border-radius: 6px;
    font-weight: 500;
    cursor: pointer;
    transition: 0.3s;
}

.btn-submit:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(102, 126, 234, 0.3);
}

.btn-cancel {
    background: #f0f0f0;
    color: #333;
    padding: 10px 30px;
    border: none;
    border-radius: 6px;
    font-weight: 500;
    cursor: pointer;
    transition: 0.3s;
    text-decoration: none;
    display: inline-block;
}

.btn-cancel:hover {
    background: #e0e0e0;
}

.file-input-wrapper {
    position: relative;
    overflow: hidden;
    display: inline-block;
    width: 100%;
}

.file-input-wrapper input[type=file] {
    position: absolute;
    left: -9999px;
}

.file-input-label {
    display: block;
    padding: 20px;
    background: #f9f9f9;
    border: 2px dashed #ddd;
    border-radius: 6px;
    text-align: center;
    cursor: pointer;
    transition: 0.3s;
}

.file-input-label:hover {
    background: #f0f0f0;
    border-color: #667eea;
}
</style>


<div class="container-fluid">
    <div class="form-container">
        <div class="form-card">
            <div class="form-header">
                <h2 class="page-title">Add New Certification</h2>
                <a href="certification.php" class="btn btn-cancel" style="margin-bottom: 0;">← Back</a>
            </div>

            <form method="post" enctype="multipart/form-data">
                <div class="form-group">
                    <label class="form-label">Certificate Type *</label>
                    <select name="cert_type" class="form-control" required>
                        <option value="real">Real Estate Certification</option>
                        <option value="automotive">Automotive Parts Certification</option>
                    </select>
                </div>

                <div class="form-group">
                    <label class="form-label">Certification Title *</label>
                    <input type="text" name="title" class="form-control" placeholder="Enter certification title (e.g., ISO 9001:2015)" required>
                </div>

                <div class="form-group">
                    <label class="form-label">Certificate Image *</label>
                    <div class="file-input-wrapper">
                        <input type="file" id="image" name="image" accept="image/*" required onchange="displayFileName(this)">
                        <label for="image" class="file-input-label">
                            <i class="fas fa-cloud-upload-alt" style="font-size: 24px; color: #667eea; margin-bottom: 10px; display: block;"></i>
                            <span id="fileName">Click to upload or drag and drop</span><br>
                            <small style="color: #999;">PNG, JPG, GIF up to 10MB</small>
                        </label>
                    </div>
                </div>

                <div class="btn-group">
                    <button type="submit" class="btn-submit">
                        <i class="fas fa-save"></i> Save Certification
                    </button>
                    <a href="certification.php" class="btn-cancel">
                        <i class="fas fa-times"></i> Cancel
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function displayFileName(input) {
    const fileName = input.files[0]?.name || 'Click to upload or drag and drop';
    document.getElementById('fileName').textContent = fileName;
}

// Drag and drop functionality
const fileInputLabel = document.querySelector('.file-input-label');
const fileInput = document.getElementById('image');

if (fileInputLabel) {
    fileInputLabel.addEventListener('dragover', (e) => {
        e.preventDefault();
        fileInputLabel.style.background = '#f0f0f0';
        fileInputLabel.style.borderColor = '#667eea';
    });

    fileInputLabel.addEventListener('dragleave', () => {
        fileInputLabel.style.background = '#f9f9f9';
        fileInputLabel.style.borderColor = '#ddd';
    });

    fileInputLabel.addEventListener('drop', (e) => {
        e.preventDefault();
        fileInputLabel.style.background = '#f9f9f9';
        fileInputLabel.style.borderColor = '#ddd';
        if (e.dataTransfer.files.length > 0) {
            fileInput.files = e.dataTransfer.files;
            displayFileName(fileInput);
        }
    });
}
</script>

<?php include "../../includes/footer.php"; ?>
