<?php 
include "../../includes/db.php";
include "../../includes/auth.php";
include "../../includes/header.php"; 
include "../../includes/sidebar.php"; 
?>

<style>
.page-header {
    margin-bottom: 30px;
    padding-bottom: 15px;
    border-bottom: 2px solid #f0f0f0;
}

.page-title {
    color: #0f2a44;
    font-weight: 600;
    font-size: 28px;
}

.table-wrapper {
    background: white;
    border-radius: 12px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.08);
    overflow: hidden;
}

.table {
    margin-bottom: 0;
}

.table thead {
    background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.table thead th {
    border: none;
    padding: 15px;
    font-weight: 600;
    font-size: 14px;
}

.table tbody tr {
    border-bottom: 1px solid #f0f0f0;
    transition: 0.3s;
}

.table tbody tr:hover {
    background: #f9f9f9;
}

.table td {
    padding: 15px;
    vertical-align: middle;
    font-size: 14px;
}

.cert-image {
    width: 60px;
    height: 60px;
    object-fit: cover;
    border-radius: 6px;
    border: 2px solid #f0f0f0;
}

.empty-state {
    text-align: center;
    padding: 40px;
    color: #999;
}

.empty-state i {
    font-size: 48px;
    margin-bottom: 15px;
    color: #ddd;
}
</style>

<div class="container-fluid">
    <div class="page-header d-flex justify-content-between align-items-center">
        <h2 class="page-title mb-0">Certifications</h2>
        <a href="add_certification.php" class="btn btn-primary" style="background:linear-gradient(90deg, #667eea 0%, #764ba2 100%); border:none; padding:10px 25px;">
            <i class="fas fa-plus"></i> Add Certification
        </a>
    </div>

    <div class="table-wrapper">
        <table class="table align-middle">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Image</th>
                    <th>Title</th>
                    <th>Type</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
<?php
$result = $conn->query("SELECT * FROM certifications ORDER BY id DESC");
$autoResult = $conn->query("SELECT * FROM automotive_certifications ORDER BY id DESC");
if (($result && $result->num_rows > 0) || ($autoResult && $autoResult->num_rows > 0)) {
    $i = 1;
    if ($result && $result->num_rows > 0) {
        while($row = $result->fetch_assoc()):
            $imagePath = $row['image'] ?? '';
            $imagePath = basename(str_replace(['../', '..\\'], '', $imagePath));
            $imageUrl = '';
            if (!empty($imagePath)) {
                $imageUrl = "/firstchoice_admin/files/" . $imagePath;
            }
?>
                <tr>
                    <td><?= $i++ ?></td>
                    <td>
                        <?php if (!empty($imageUrl)): ?>
                            <img src="<?= htmlspecialchars($imageUrl) ?>" alt="Certificate" class="cert-image" onerror="this.onerror=null;this.src='/firstchoice_admin/admin/files/<?= htmlspecialchars($imagePath) ?>';">
                        <?php else: ?>
                            <span class="text-muted">No image</span>
                        <?php endif; ?>
                    </td>
                    <td><?= htmlspecialchars($row['title']) ?></td>
                    <td><span class="badge bg-success">Real Estate</span></td>
                    <td>
                        <a href="edit_certification.php?id=<?= $row['id'] ?>&type=real" class="btn btn-sm btn-primary">Edit</a>
                        <form action="delete_certification.php" method="POST" style="display:inline;" onsubmit="return confirm('Are you sure you want to delete this certification?');">
                            <input type="hidden" name="id" value="<?= $row['id'] ?>">
                            <input type="hidden" name="type" value="real">
                            <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                        </form>
                    </td>
                </tr>
<?php endwhile;
    }
    if ($autoResult && $autoResult->num_rows > 0) {
        while($row = $autoResult->fetch_assoc()):
            $imagePath = $row['image'] ?? '';
            $imagePath = basename(str_replace(['../', '..\\'], '', $imagePath));
            $imageUrl = '';
            if (!empty($imagePath)) {
                $imageUrl = "/firstchoice_admin/files/" . $imagePath;
            }
?>
                <tr>
                    <td><?= $i++ ?></td>
                    <td>
                        <?php if (!empty($imageUrl)): ?>
                            <img src="<?= htmlspecialchars($imageUrl) ?>" alt="Certificate" class="cert-image" onerror="this.onerror=null;this.src='/firstchoice_admin/admin/files/<?= htmlspecialchars($imagePath) ?>';">
                        <?php else: ?>
                            <span class="text-muted">No image</span>
                        <?php endif; ?>
                    </td>
                    <td><?= htmlspecialchars($row['title']) ?></td>
                    <td><span class="badge bg-warning text-dark">Automotive</span></td>
                    <td>
                        <a href="edit_certification.php?id=<?= $row['id'] ?>&type=automotive" class="btn btn-sm btn-primary">Edit</a>
                        <form action="delete_certification.php" method="POST" style="display:inline;" onsubmit="return confirm('Are you sure you want to delete this certification?');">
                            <input type="hidden" name="id" value="<?= $row['id'] ?>">
                            <input type="hidden" name="type" value="automotive">
                            <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                        </form>
                    </td>
                </tr>
<?php endwhile;
    }
} else {
    echo '<tr><td colspan="5"><div class="empty-state"><i class="fas fa-certificate"></i><p>No certifications found</p></div></td></tr>';
}
?>
            </tbody>
        </table>
    </div>
</div>

<script>
function deleteCertification(id) {
    if (confirm('Are you sure you want to delete this certification?')) {
        fetch('delete_certification.php', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: 'id=' + id
        }).then(() => location.reload());
    }
}
</script>

<?php include "../../includes/footer.php"; ?>
