<?php 
include "../../includes/db.php";
include "../../includes/auth.php";
include "../../includes/header.php"; 
include "../../includes/sidebar.php"; 
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="page-title">Projects</h2>
    <a href="add_project.php" class="btn btn-dark">+ Add Project</a>
</div>

<table class="table table-bordered bg-white">
<tr>
    <th>#</th>
    <th>Image</th>
    <th>Title</th>
    <th>Type</th>
    <th>Status</th>
    <th>Action</th>
</tr>

<?php
$result = $conn->query("SELECT * FROM projects ORDER BY id DESC");
if ($result && $result->num_rows > 0) {
    $i = 1;
    while($row = $result->fetch_assoc()):
?>
<tr>
    <td><?= $i++ ?></td>
    <td>
        <?php
        $thumbs = [];
        if (!empty($row['image'])) {
            $thumbs[] = "/firstchoice_admin/" . ltrim($row['image'], '/');
        }
        $imgTable = $conn->query("SHOW TABLES LIKE 'project_images'");
        if ($imgTable && $imgTable->num_rows > 0) {
            $gRes = $conn->query("SELECT image FROM project_images WHERE project_id=".(int)$row['id']." ORDER BY id ASC");
            while ($gRes && ($g = $gRes->fetch_assoc())) {
                if (!empty($g['image'])) {
                    $thumbs[] = "/firstchoice_admin/" . ltrim($g['image'], '/');
                }
            }
        }
        $thumbs = array_values(array_unique($thumbs));
        ?>
        <?php if (!empty($thumbs)): ?>
            <div style="display:flex; gap:6px; flex-wrap:wrap;">
                <?php foreach ($thumbs as $t): ?>
                    <img src="<?= htmlspecialchars($t) ?>" width="42" height="42" style="object-fit:cover;border-radius:5px;border:1px solid #eee;">
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <span class="text-muted">No image</span>
        <?php endif; ?>
    </td>
    <td><?= htmlspecialchars($row['title']) ?></td>
    <td><?= htmlspecialchars($row['type'] ?? 'Civil') ?></td>
    <td>
        <span class="badge bg-<?= $row['status'] == 'completed' ? 'success' : ($row['status'] == 'ongoing' ? 'info' : 'warning') ?>">
            <?= ucfirst($row['status']) ?>
        </span>
    </td>
    <td>
        <a href="edit_project.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-primary">Edit</a>
        <form action="delete_project.php" method="POST" style="display:inline;" onsubmit="return confirm('Are you sure you want to delete this project?');">
            <input type="hidden" name="id" value="<?= $row['id'] ?>">
            <button type="submit" class="btn btn-sm btn-danger">Delete</button>
        </form>
    </td>
</tr>
<?php endwhile;
} else {
    echo '<tr><td colspan="6" class="text-center text-muted">No projects found</td></tr>';
}
?>
</table>

<script>
function deleteProject(id) {
    if (confirm('Are you sure you want to delete this project?')) {
        fetch('delete_project.php', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: 'id=' + id
        }).then(() => location.reload());
    }
}
</script>

<?php include "../../includes/footer.php"; ?>
