<?php 
include "../../includes/db.php";
include "../../includes/auth.php";
if ($_POST) {
    $title = mysqli_real_escape_string($conn, $_POST['title']);
    $description = mysqli_real_escape_string($conn, $_POST['description']);
    $icon = mysqli_real_escape_string($conn, $_POST['icon']);
    $featuresRaw = $_POST['features'] ?? '';

    $conn->query("INSERT INTO services (title, description, icon) 
                  VALUES ('$title', '$description', '$icon')");
    $serviceId = $conn->insert_id;

    if (!empty($featuresRaw)) {
        $lines = preg_split('/\r\n|\r|\n/', $featuresRaw);
        foreach ($lines as $line) {
            $feature = trim($line);
            if ($feature !== '') {
                $featureEsc = mysqli_real_escape_string($conn, $feature);
                $conn->query("INSERT INTO service_features (service_id, feature) VALUES ($serviceId, '$featureEsc')");
            }
        }
    }

    header("Location: services.php");
    exit;
}
?>

<?php 
include "../../includes/header.php"; 
include "../../includes/sidebar.php"; 
?>

<div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:30px; padding-bottom:15px; border-bottom:2px solid #f0f0f0;">
    <h2 class="page-title" style="margin:0;">Add Service</h2>
    <a href="services.php" style="display:inline-block; padding:10px 20px; background:#f0f0f0; color:#333; text-decoration:none; border-radius:6px; font-weight:500; transition:0.3s;">
        <i class="fas fa-arrow-left"></i> Back to Services
    </a>
</div>

<form method="post" class="bg-white p-4 rounded">
    <div class="mb-3">
        <label class="form-label">Service Title</label>
        <input type="text" name="title" class="form-control" placeholder="Enter service title" required>
    </div>

    <div class="mb-3">
        <label class="form-label">Font Awesome Icon</label>
        <input type="text" name="icon" class="form-control" 
               placeholder="e.g., fa-solid fa-hammer or fa fa-hammer" required>
        <small class="text-muted">Visit <a href="https://fontawesome.com" target="_blank">fontawesome.com</a> for icon names</small>
    </div>

    <div class="mb-3">
        <label class="form-label">Service Description</label>
        <textarea name="description" class="form-control" 
                  placeholder="Enter service description" rows="5" required></textarea>
    </div>

    <div class="mb-3">
        <label class="form-label">Service Features</label>
        <textarea name="features" class="form-control" rows="5" placeholder="One feature per line"></textarea>
        <small class="text-muted">Example: Fast response, Licensed team, 24/7 support</small>
    </div>

    <button type="submit" class="btn btn-dark">Save Service</button>
    <a href="services.php" class="btn btn-secondary">Cancel</a>
</form>

<?php include "../../includes/footer.php"; ?>
