<?php 
include "../../includes/db.php";
include "../../includes/auth.php";

$id = (int)$_GET['id'];
$service = $conn->query("SELECT * FROM services WHERE id=$id")->fetch_assoc();

if (!$service) {
    header("Location: services.php");
    exit;
}

if ($_POST) {
    $title = mysqli_real_escape_string($conn, $_POST['title']);
    $description = mysqli_real_escape_string($conn, $_POST['description']);
    $icon = mysqli_real_escape_string($conn, $_POST['icon']);
    $featuresRaw = $_POST['features'] ?? '';

    $conn->query("UPDATE services SET 
                  title='$title', 
                  description='$description', 
                  icon='$icon'
                  WHERE id=$id");

    $conn->query("DELETE FROM service_features WHERE service_id=$id");
    if (!empty($featuresRaw)) {
        $lines = preg_split('/\r\n|\r|\n/', $featuresRaw);
        foreach ($lines as $line) {
            $feature = trim($line);
            if ($feature !== '') {
                $featureEsc = mysqli_real_escape_string($conn, $feature);
                $conn->query("INSERT INTO service_features (service_id, feature) VALUES ($id, '$featureEsc')");
            }
        }
    }

    header("Location: services.php");
    exit;
}

include "../../includes/header.php"; 
include "../../includes/sidebar.php"; 
?>

<h2 class="page-title">Edit Service</h2>

<?php
$featuresList = [];
$featuresRes = $conn->query("SELECT feature FROM service_features WHERE service_id=$id ORDER BY id ASC");
if ($featuresRes && $featuresRes->num_rows > 0) {
    while ($f = $featuresRes->fetch_assoc()) {
        $featuresList[] = $f['feature'];
    }
}
$featuresText = implode("\n", $featuresList);
?>

<form method="post" class="bg-white p-4 rounded">
    <div class="mb-3">
        <label class="form-label">Service Title</label>
        <input type="text" name="title" value="<?= htmlspecialchars($service['title']) ?>" class="form-control" required>
    </div>

    <div class="mb-3">
        <label class="form-label">Font Awesome Icon</label>
        <input type="text" name="icon" value="<?= htmlspecialchars($service['icon']) ?>" class="form-control" required>
        <small class="text-muted">Visit <a href="https://fontawesome.com" target="_blank">fontawesome.com</a> for icon names</small>
    </div>

    <div class="mb-3">
        <label class="form-label">Service Description</label>
        <textarea name="description" class="form-control" rows="5" required><?= htmlspecialchars($service['description']) ?></textarea>
    </div>

    <div class="mb-3">
        <label class="form-label">Service Features</label>
        <textarea name="features" class="form-control" rows="5" placeholder="One feature per line"><?= htmlspecialchars($featuresText) ?></textarea>
        <small class="text-muted">Example: Fast response, Licensed team, 24/7 support</small>
    </div>

    <button type="submit" class="btn btn-primary">Update Service</button>
    <a href="services.php" class="btn btn-secondary">Cancel</a>
</form>

<?php include "../../includes/footer.php"; ?>
