<?php 
include "../../includes/db.php";
include "../../includes/auth.php";
include "../../includes/header.php"; 
include "../../includes/sidebar.php"; 
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="page-title">Services</h2>
    <a href="add_services.php" class="btn btn-dark">+ Add Service</a>
</div>

<table class="table table-bordered bg-white">
<tr>
    <th>#</th>
    <th>Icon</th>
    <th>Title</th>
    <th>Description</th>
    <th>Action</th>
</tr>

<?php
$result = $conn->query("SELECT * FROM services ORDER BY id DESC");
if ($result && $result->num_rows > 0) {
    $i = 1;
    while($row = $result->fetch_assoc()):
?>
<tr>
    <td><?= $i++ ?></td>
    <td><i class="<?= htmlspecialchars($row['icon']) ?>"></i></td>
    <td><?= htmlspecialchars($row['title']) ?></td>
    <td><?= substr(htmlspecialchars($row['description']), 0, 60) ?>...</td>
    <td>
        <a href="edit_service.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-primary">Edit</a>
        <form action="delete_service.php" method="POST" style="display:inline;" onsubmit="return confirm('Are you sure you want to delete this service?');">
            <input type="hidden" name="id" value="<?= $row['id'] ?>">
            <button type="submit" class="btn btn-sm btn-danger">Delete</button>
        </form>
    </td>
</tr>
<?php endwhile;
} else {
    echo '<tr><td colspan="5" class="text-center text-muted">No services found</td></tr>';
}
?>
</table>

<script>
function deleteService(id) {
    if (confirm('Are you sure you want to delete this service?')) {
        fetch('delete_service.php', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: 'id=' + id
        }).then(() => location.reload());
    }
}
</script>

<?php include "../../includes/footer.php"; ?>
