<?php 
include "../../includes/db.php";
include "../../includes/auth.php";
?>

<?php
if ($_POST) {
    $name = mysqli_real_escape_string($conn, $_POST['name'] ?? '');
    $role = mysqli_real_escape_string($conn, $_POST['role'] ?? '');
    $email = mysqli_real_escape_string($conn, $_POST['email'] ?? '');
    $phone = mysqli_real_escape_string($conn, $_POST['phone'] ?? '');
    $bio = mysqli_real_escape_string($conn, $_POST['bio'] ?? '');

    $photo = '';
    if (!empty($_FILES['photo']['name'])) {
        $upload_dir = dirname(__DIR__, 3) . DIRECTORY_SEPARATOR . "files" . DIRECTORY_SEPARATOR;
        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0755, true);
        }
        $filename = time() . "_" . basename($_FILES["photo"]["name"]);
        $target_file = $upload_dir . $filename;
        move_uploaded_file($_FILES["photo"]["tmp_name"], $target_file);
        // Store a web path that works for frontend and admin
        $photo = "../../../files/" . $filename;
    }

    $conn->query("INSERT INTO team (name, role, email, phone, photo, bio) 
                  VALUES ('$name', '$role', '$email', '$phone', '$photo', '$bio')");

    header("Location: team.php");
    exit;
}

include "../../includes/header.php"; 
include "../../includes/sidebar.php"; 
?>

<div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:30px; padding-bottom:15px; border-bottom:2px solid #f0f0f0;">
    <h2 class="page-title" style="margin:0;">Add Team Member</h2>
    <a href="team.php" style="display:inline-block; padding:10px 20px; background:#f0f0f0; color:#333; text-decoration:none; border-radius:6px; font-weight:500; transition:0.3s;">
        <i class="fas fa-arrow-left"></i> Back to Team
    </a>
</div>

<form method="post" enctype="multipart/form-data" class="bg-white p-4 rounded">
    <div class="mb-3">
        <label class="form-label">Full Name</label>
        <input type="text" name="name" class="form-control" placeholder="Enter full name" required>
    </div>

    <div class="mb-3">
        <label class="form-label">Position / Role</label>
        <input type="text" name="role" class="form-control" placeholder="Enter position or role" required>
    </div>

    <div class="mb-3">
        <label class="form-label">Email</label>
        <input type="email" name="email" class="form-control" placeholder="Enter email address">
    </div>

    <div class="mb-3">
        <label class="form-label">Phone</label>
        <input type="tel" name="phone" class="form-control" placeholder="Enter phone number">
    </div>

    <div class="mb-3">
        <label class="form-label">Bio</label>
        <textarea name="bio" class="form-control" placeholder="Enter member bio" rows="4"></textarea>
    </div>

    <div class="mb-3">
        <label class="form-label">Photo</label>
        <input type="file" name="photo" class="form-control" accept="image/*" required>
    </div>

    <button type="submit" class="btn btn-dark">Save Member</button>
    <a href="team.php" class="btn btn-secondary">Cancel</a>
</form>

<?php include "../../includes/footer.php"; ?>
