<?php 
include "../../includes/db.php";
include "../../includes/auth.php";
?>

<?php
$id = (int)$_GET['id'];
$member = $conn->query("SELECT * FROM team WHERE id=$id")->fetch_assoc();

if (!$member) {
    header("Location: team.php");
    exit;
}

if ($_POST) {
    $name = mysqli_real_escape_string($conn, $_POST['name'] ?? '');
    $role = mysqli_real_escape_string($conn, $_POST['role'] ?? '');
    $email = mysqli_real_escape_string($conn, $_POST['email'] ?? '');
    $phone = mysqli_real_escape_string($conn, $_POST['phone'] ?? '');
    $bio = mysqli_real_escape_string($conn, $_POST['bio'] ?? '');

    $photo = $member['photo'];
    if (!empty($_FILES['photo']['name'])) {
        $upload_dir = dirname(__DIR__, 3) . DIRECTORY_SEPARATOR . "files" . DIRECTORY_SEPARATOR;
        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0755, true);
        }
        $filename = time() . "_" . basename($_FILES["photo"]["name"]);
        $target_file = $upload_dir . $filename;
        move_uploaded_file($_FILES["photo"]["tmp_name"], $target_file);
        // Store a web path that works for frontend and admin
        $photo = "../../../files/" . $filename;
    }

    $conn->query("UPDATE team SET 
                  name='$name', 
                  role='$role',
                  email='$email',
                  phone='$phone',
                  photo='$photo',
                  bio='$bio'
                  WHERE id=$id");
    header("Location: team.php");
    exit;
}

include "../../includes/header.php"; 
include "../../includes/sidebar.php"; 
?>

<h2 class="page-title">Edit Team Member</h2>

<form method="post" enctype="multipart/form-data" class="bg-white p-4 rounded">
    <div class="mb-3">
        <label class="form-label">Full Name</label>
        <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($member['name']) ?>" required>
    </div>

    <div class="mb-3">
        <label class="form-label">Position / Role</label>
        <input type="text" name="role" class="form-control" value="<?= htmlspecialchars($member['role'] ?? '') ?>" required>
    </div>

    <div class="mb-3">
        <label class="form-label">Email</label>
        <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($member['email'] ?? '') ?>">
    </div>

    <div class="mb-3">
        <label class="form-label">Phone</label>
        <input type="tel" name="phone" class="form-control" value="<?= htmlspecialchars($member['phone'] ?? '') ?>">
    </div>

    <div class="mb-3">
        <label class="form-label">Bio</label>
        <textarea name="bio" class="form-control" rows="4"><?= htmlspecialchars($member['bio'] ?? '') ?></textarea>
    </div>

    <div class="mb-3">
        <label class="form-label">Photo</label>
        <?php if ($member['photo']): ?>
            <div class="mb-2">
                <img src="<?= $member['photo'] ?>" width="100" height="100" style="object-fit:cover;border-radius:50%">
            </div>
        <?php endif; ?>
        <input type="file" name="photo" class="form-control" accept="image/*">
        <small class="text-muted">Leave empty to keep current photo</small>
    </div>

    <button type="submit" class="btn btn-primary">Update Member</button>
    <a href="team.php" class="btn btn-secondary">Cancel</a>
</form>

<?php include "../../includes/footer.php"; ?>
