<?php 
include "../../includes/db.php";
include "../../includes/auth.php";
include "../../includes/header.php"; 
include "../../includes/sidebar.php"; 
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="page-title">Team Members</h2>
    <a href="add_team.php" class="btn btn-dark">+ Add Member</a>
</div>

<table class="table table-bordered bg-white align-middle">
<tr>
    <th>#</th>
    <th>Photo</th>
    <th>Name</th>
    <th>Role</th>
    <th>Action</th>
</tr>

<?php
$result = $conn->query("SELECT * FROM team ORDER BY id DESC");
if ($result && $result->num_rows > 0) {
    $i = 1;
    while($row = $result->fetch_assoc()):
?>
<tr>
    <td><?= $i++ ?></td>
    <td>
        <?php if ($row['photo']): ?>
            <img src="<?= $row['photo'] ?>" width="50" height="50" style="object-fit:cover;border-radius:50%">
        <?php else: ?>
            <span class="text-muted">No photo</span>
        <?php endif; ?>
    </td>
    <td><?= htmlspecialchars($row['name']) ?></td>
    <td><?= htmlspecialchars($row['role'] ?? 'N/A') ?></td>
    <td>
        <a href="edit_team.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-primary">Edit</a>
        <form action="delete_team.php" method="POST" style="display:inline;" onsubmit="return confirm('Are you sure you want to delete this team member?');">
            <input type="hidden" name="id" value="<?= $row['id'] ?>">
            <button type="submit" class="btn btn-sm btn-danger">Delete</button>
        </form>
    </td>
</tr>
<?php endwhile;
} else {
    echo '<tr><td colspan="5" class="text-center text-muted">No team members found</td></tr>';
}
?>
</table>

<script>
function deleteTeam(id) {
    if (confirm('Are you sure you want to delete this team member?')) {
        fetch('delete_team.php', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: 'id=' + id
        }).then(() => location.reload());
    }
}
</script>

<?php include "../../includes/footer.php"; ?>
