
<?php
include 'config.php';
$currentPage = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Certifications | First Choice Real Estate</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
<link rel="stylesheet" href="assests/style.css">
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

</head>
<body> 
 <!-- HEADER -->
  <header>
    <div class="navbar">
      <a class="logo" href="./index.php"><img src="assests/images/headlogo.png" alt="First Choice"></a>
      <button class="nav-toggle" aria-label="Toggle navigation" aria-expanded="false">
        <span></span>
      </button>
      <nav class="nav">
        <ul>
          <li><a href="./index.php" class="<?= $currentPage === 'index.php' ? 'active' : '' ?>">Home</a></li>
          <li><a href="./aboutus.php" class="<?= $currentPage === 'aboutus.php' ? 'active' : '' ?>">About Us</a></li>
          <li><a href="./certification.php" class="<?= $currentPage === 'certification.php' ? 'active' : '' ?>">Certification</a></li>
          <li><a href="./team.php" class="<?= $currentPage === 'team.php' ? 'active' : '' ?>">Team</a></li>
          <li><a href="./projects.php" class="<?= $currentPage === 'projects.php' ? 'active' : '' ?>">Projects</a></li>
                    <li><a href="./services.php" class="<?= $currentPage === 'services.php' ? 'active' : '' ?>">Services</a></li>
          <li><a href="./contactus.php" class="<?= $currentPage === 'contactus.php' ? 'active' : '' ?>">Contact Us</a></li>
        </ul>
      </nav>
    </div>
  </header>
  <!-- HERO -->
  <section class="hero">
    <div class="hero-inner container">
      <div class="hero-content">
        <span class="hero-kicker">Certified Excellence</span>
        <h1>Proof of Quality. Assurance in Every Build.</h1>
        <p>Our certifications reflect rigorous standards in construction, safety, and interior execution. We build trust through compliance, documented processes, and accountable delivery.</p>
        <div class="hero-actions">
          <a class="hero-cta" href="./contactus.php">Request a Consultation</a>
          <a class="hero-ghost" href="./projects.php">View Projects</a>
        </div>
        <div class="hero-meta">
          <div class="hero-stat">
            <strong>Certified</strong>
            <span>Recognized for quality and safety systems</span>
          </div>
          <div class="hero-stat">
            <strong>Audited</strong>
            <span>Documented processes and compliance checks</span>
          </div>
          <div class="hero-stat">
            <strong>Trusted</strong>
            <span>Consistent delivery across UAE and Oman</span>
          </div>
        </div>
      </div>
      <div class="hero-card">
        <h4>Certification Focus</h4>
        <ul>
          <li><i class="fa-solid fa-check"></i> Civil construction quality and supervision</li>
          <li><i class="fa-solid fa-check"></i> Interior and decor compliance standards</li>
          <li><i class="fa-solid fa-check"></i> Safety management and site controls</li>
          <li><i class="fa-solid fa-check"></i> Continuous improvement and audits</li>
        </ul>
      </div>
    </div>
  </section>

  
<section class="certifications" id="certifications">
  <div class="cert-container" style="text-align:center;">
    <h2 class="cert-title">Our Certifications</h2>
    <p class="cert-subtitle">
      We are officially certified to deliver quality civil construction and professional interior & décor works.
    </p>

    <div class="cert-heading">
      First Choice Real General Contracting Certificates
    </div>

    <div class="cert-grid">
      <?php
      $certs = $conn->query("SELECT * FROM certifications ORDER BY id DESC");
      while($row = $certs->fetch_assoc()):
        $imagePath = $row['image'] ?? '';
        $imagePath = basename(str_replace(['../', '..\\'], '', $imagePath));
        $imageUrl = '';
        if (!empty($imagePath)) {
          $imageUrl = '/firstchoice_admin/files/' . $imagePath;
        }
      ?>
        <div class="cert-card" onclick="openCert('<?php echo $imagePath; ?>')">
          <?php if (!empty($imageUrl)): ?>
            <img src="<?php echo $imageUrl; ?>" alt="<?php echo htmlspecialchars($row['title']); ?>" onerror="this.onerror=null;this.src='/firstchoice_admin/admin/files/<?php echo htmlspecialchars($imagePath); ?>';">
          <?php endif; ?>
          <h3><?php echo htmlspecialchars($row['title']); ?></h3>
        </div>
      <?php endwhile; ?>
    </div>

    <div class="cert-heading" style="margin-top:40px; text-align:center;">
      First Choice Automotive Certificates
    </div>

    <div class="cert-grid">
      <?php
      $autoCerts = $conn->query("SELECT * FROM automotive_certifications ORDER BY id DESC");
      while($row = $autoCerts->fetch_assoc()):
        $imagePath = $row['image'] ?? '';
        $imagePath = basename(str_replace(['../', '..\\'], '', $imagePath));
        $imageUrl = '';
        if (!empty($imagePath)) {
          $imageUrl = '/firstchoice_admin/files/' . $imagePath;
        }
      ?>
        <div class="cert-card" onclick="openCert('<?php echo $imagePath; ?>')">
          <?php if (!empty($imageUrl)): ?>
            <img src="<?php echo $imageUrl; ?>" alt="<?php echo htmlspecialchars($row['title']); ?>" onerror="this.onerror=null;this.src='/firstchoice_admin/admin/files/<?php echo htmlspecialchars($imagePath); ?>';">
          <?php endif; ?>
          <h3><?php echo htmlspecialchars($row['title']); ?></h3>
        </div>
      <?php endwhile; ?>
    </div>
  </div>
</section>

<!-- Modal -->
<div class="cert-modal" id="certModal">
  <span class="close" onclick="closeCert()">&times;</span>
  <img id="certImage">
</div>

<script>
function openCert(imgSrc) {
  const modal = document.getElementById('certModal');
  const modalImg = document.getElementById('certImage');
  modal.style.display = 'block';
  if (!imgSrc) return;
  if (imgSrc.indexOf('/') === -1) {
    modalImg.src = '/firstchoice_admin/files/' + imgSrc;
    modalImg.onerror = function() {
      this.onerror = null;
      this.src = '/firstchoice_admin/admin/files/' + imgSrc;
    };
  } else {
    modalImg.src = imgSrc;
  }
}

function closeCert() {
  const modal = document.getElementById('certModal');
  modal.style.display = 'none';
}

document.addEventListener('click', function(e) {
  const modal = document.getElementById('certModal');
  if (e.target === modal) {
    modal.style.display = 'none';
  }
});

document.addEventListener('keydown', function(e) {
  if (e.key === 'Escape') {
    document.getElementById('certModal').style.display = 'none';
  }
});
</script>
<!-- FOOTER -->
  <footer>
    <p>
      First Choice Group of Companies <br>
      First Choice Real General Contracting and Maintenance LLC OPC (FCRGC) <br>
      First Choice Automotive Parts Cars Sole Proprietorship LLC (FCAPC) <br>
      <br>
      © 2024-2025
    </p>
  </footer>

<script src="./script.js"></script>

<script>
function openCert(imgSrc) {
  const modal = document.getElementById('certModal');
  const modalImg = document.getElementById('certImage');
  modal.style.display = 'block';
  if (!imgSrc) return;
  if (imgSrc.indexOf('/') === -1) {
    modalImg.src = '/firstchoice_admin/files/' + imgSrc;
    modalImg.onerror = function() {
      this.onerror = null;
      this.src = '/firstchoice_admin/admin/files/' + imgSrc;
    };
  } else {
    modalImg.src = imgSrc;
  }
}

function closeCert() {
  const modal = document.getElementById('certModal');
  modal.style.display = 'none';
}

document.addEventListener('click', function(e) {
  const modal = document.getElementById('certModal');
  if (e.target === modal) {
    modal.style.display = 'none';
  }
});

document.addEventListener('keydown', function(e) {
  if (e.key === 'Escape') {
    document.getElementById('certModal').style.display = 'none';
  }
});
</script>



  <script src="assests/site.js"></script>
</body>
</html>
