<?php
include 'config.php';
$currentPage = basename($_SERVER['PHP_SELF']);

$success = '';
$error = '';
if (isset($_GET['sent']) && $_GET['sent'] === '1') {
    $success = "Message sent successfully! We will contact you soon.";
}
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    $subject = trim($_POST['subject'] ?? '');
    $message = trim($_POST['message'] ?? '');

    if ($name === '' || $email === '' || $message === '') {
        $error = "Please fill in your name, email, and message.";
    } else {
        $cols = [];
        $colRes = $conn->query("SHOW COLUMNS FROM messages");
        if ($colRes) {
            while ($c = $colRes->fetch_assoc()) {
                $cols[$c['Field']] = true;
            }
        }

        $fields = [];
        $placeholders = [];
        $types = '';
        $values = [];

        if (!empty($cols['name'])) {
            $fields[] = 'name';
            $placeholders[] = '?';
            $types .= 's';
            $values[] = $name;
        }
        if (!empty($cols['email'])) {
            $fields[] = 'email';
            $placeholders[] = '?';
            $types .= 's';
            $values[] = $email;
        }
        if (!empty($cols['phone'])) {
            $fields[] = 'phone';
            $placeholders[] = '?';
            $types .= 's';
            $values[] = $phone;
        }
        if (!empty($cols['subject'])) {
            $fields[] = 'subject';
            $placeholders[] = '?';
            $types .= 's';
            $values[] = $subject;
        }
        if (!empty($cols['message'])) {
            $fields[] = 'message';
            $placeholders[] = '?';
            $types .= 's';
            $values[] = $message;
        }

        if (count($fields) === 0) {
            $error = "Message table is missing required columns.";
        } else {
            $sql = "INSERT INTO messages (" . implode(', ', $fields) . ") VALUES (" . implode(', ', $placeholders) . ")";
            $stmt = $conn->prepare($sql);
            if ($stmt) {
                $stmt->bind_param($types, ...$values);
                $stmt->execute();
                if ($stmt->affected_rows > 0) {
                    $success = "Message sent successfully! We will contact you soon.";
                    $returnTo = trim($_POST['return_to'] ?? '');
                    $_POST = [];
                    if ($returnTo !== '' && preg_match('/^[A-Za-z0-9._\\/-]+\\.php$/', $returnTo)) {
                        header("Location: " . $returnTo . "?sent=1");
                        exit;
                    }
                } else {
                    $error = "Message could not be sent. Please try again.";
                }
                $stmt->close();
            } else {
                $error = "Message could not be sent. Please try again.";
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Contact Us | First Choice Real Estate</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
  <link rel="stylesheet" href="assests/style.css">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>

  <!-- HEADER -->
  <header>
    <div class="navbar">
      <a class="logo" href="./index.php"><img src="assests/images/headlogo.png" alt="First Choice"></a>
      <button class="nav-toggle" aria-label="Toggle navigation" aria-expanded="false">
        <span></span>
      </button>
      <nav class="nav">
        <ul>
          <li><a href="./index.php" class="<?= $currentPage === 'index.php' ? 'active' : '' ?>">Home</a></li>
          <li><a href="./aboutus.php" class="<?= $currentPage === 'aboutus.php' ? 'active' : '' ?>">About Us</a></li>
          <li><a href="./certification.php" class="<?= $currentPage === 'certification.php' ? 'active' : '' ?>">Certification</a></li>
          <li><a href="./team.php" class="<?= $currentPage === 'team.php' ? 'active' : '' ?>">Team</a></li>
          <li><a href="./projects.php" class="<?= $currentPage === 'projects.php' ? 'active' : '' ?>">Projects</a></li>
          <li><a href="./services.php" class="<?= $currentPage === 'services.php' ? 'active' : '' ?>">Services</a></li>
          <li><a href="./contactus.php" class="<?= $currentPage === 'contactus.php' ? 'active' : '' ?>">Contact Us</a></li>
        </ul>
      </nav>
    </div>
  </header>
  <!-- HERO -->
  <section class="hero">
    <div class="hero-inner container">
      <div class="hero-content">
        <span class="hero-kicker">Contact Us</span>
        <h1>Let�s Build Something Exceptional Together.</h1>
        <p>Tell us about your project needs and timeline. Our team will respond quickly with clear guidance, scope options, and next steps.</p>
        <div class="hero-actions">
          <a class="hero-cta" href="#contact-form">Send a Message</a>
          <a class="hero-ghost" href="./projects.php">View Projects</a>
        </div>
        <div class="hero-meta">
          <div class="hero-stat">
            <strong>Fast Response</strong>
            <span>Clear communication from day one</span>
          </div>
          <div class="hero-stat">
            <strong>Expert Advice</strong>
            <span>Guidance from experienced leaders</span>
          </div>
          <div class="hero-stat">
            <strong>Trusted Delivery</strong>
            <span>Quality-first, on-time execution</span>
          </div>
        </div>
      </div>
      <div class="hero-card">
        <h4>What We Can Help With</h4>
        <ul>
          <li><i class="fa-solid fa-check"></i> New construction and villa delivery</li>
          <li><i class="fa-solid fa-check"></i> Interior fit-out and decor works</li>
          <li><i class="fa-solid fa-check"></i> MEP services and maintenance</li>
          <li><i class="fa-solid fa-check"></i> Steel fabrication and carpentry</li>
        </ul>
      </div>
    </div>
  </section>

 <!-- CONTACT US PAGE -->
<section id="contact-form" class="section-light">
  <div class="container">
<!-- SECTION TITLE -->
    <div class="section-title">
      <h2>Contact Us</h2>
      <p>
        Have questions or want to discuss a project? Get in touch with our professional team.
      </p>
    </div>

    <!-- CONTACT CONTENT -->
    <div class="contact-layout">

      <!-- CONTACT FORM -->
      <div class="contact-form-card contact-form-area">
        <?php if (!empty($success)): ?>
          <div class="alert-msg success">
            <?= htmlspecialchars($success) ?>
          </div>
        <?php elseif (!empty($error)): ?>
          <div class="alert-msg error">
            <?= htmlspecialchars($error) ?>
          </div>
        <?php endif; ?>
        <form method="POST" action="contactus.php">
          <input type="hidden" name="return_to" value="contactus.php">
          <input type="text" name="name" placeholder="Your Name" required value="<?= htmlspecialchars($_POST['name'] ?? '') ?>">
          <input type="email" name="email" placeholder="Your Email" required value="<?= htmlspecialchars($_POST['email'] ?? '') ?>">
          <input type="text" name="phone" placeholder="Phone (optional)" value="<?= htmlspecialchars($_POST['phone'] ?? '') ?>">
          <input type="text" name="subject" placeholder="Subject" value="<?= htmlspecialchars($_POST['subject'] ?? '') ?>">
          <textarea rows="6" name="message" placeholder="Your Message" required><?= htmlspecialchars($_POST['message'] ?? '') ?></textarea>
          <button type="submit">Send Message</button>
        </form>
      </div>

      <!-- CONTACT INFO -->
      <div class="contact-info-card contact-info-area">
        <h3>Get in Touch</h3>
        <p>We are here to answer your questions and provide solutions for your projects.</p>

        <div class="contact-item">
          <span>📍</span>
          <p>Musaffah - MW4 - Abu Dhabi - United Arab Emirates</p>
        </div>

        <div class="contact-item">
          <span>📞</span>
          <p>+971 2 557 1642 , +971 55 315 9291</p>
        </div>

        <div class="contact-item">
          <span>✉️</span>
          <p>firstchoice.rgc@gmail.com</p>
        </div>

        <div class="contact-item">
          <span>⏰</span>
          <p>Mon - Sat: 9:00 AM - 6:00 PM</p>
        </div>
      </div>

    </div>
  </div>
</section>


<!-- MAP -->
<section class="map-section">
  <div class="container">
    <div class="section-title" style="margin-bottom:30px;">
      <h2>Find Us</h2>
      <p>Visit our office in Abu Dhabi or contact us for directions.</p>
    </div>
    <div class="map-frame">
      <iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d14290.077849723239!2d54.47011839343603!3d24.347671143171844!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3e5e41db146f2b6b%3A0xc912144a8c250fc5!2sFirst%20Choice%20Real%20General%20Contracting%20%26%20Maint.%20LLC%20-%20OPC!5e0!3m2!1sen!2sus!4v1770548144683!5m2!1sen!2sus" width="100%" height="420" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
    </div>
  </div>
</section>
  <!-- FOOTER -->
  <footer>
    <p>
      First Choice Group of Companies <br>
      First Choice Real General Contracting and Maintenance LLC OPC (FCRGC) <br>
      First Choice Automotive Parts Cars Sole Proprietorship LLC (FCAPC) <br>
      <br>
      © 2024-2025
    </p>
  </footer>

  <script src="./script.js"></script>
  <script src="assests/site.js"></script>
</body>
</html>
