<?php
$currentPage = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>First Choice Real Estate | Professional Property Solutions</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
<link rel="stylesheet" href="assests/style.css">
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

  <style>
    @media (max-width: 768px) {
      .services {
        grid-template-columns: 1fr;
      }
    }
  </style>
  
</head>
<body>

  <!-- HEADER -->
  <header>
    <div class="navbar">
      <a class="logo" href="./index.php"><img src="assests/images/headlogo.png" alt="First Choice"></a>
      <button class="nav-toggle" aria-label="Toggle navigation" aria-expanded="false">
        <span></span>
      </button>
      <nav class="nav">
        <ul>
          <li><a href="./index.php" class="<?= $currentPage === 'index.php' ? 'active' : '' ?>">Home</a></li>
          <li><a href="./aboutus.php" class="<?= $currentPage === 'aboutus.php' ? 'active' : '' ?>">About Us</a></li>
          <li><a href="certification.php" class="<?= $currentPage === 'certification.php' ? 'active' : '' ?>">Certification</a></li>
          <li><a href="./team.php" class="<?= $currentPage === 'team.php' ? 'active' : '' ?>">Team</a></li>
          <li><a href="./projects.php" class="<?= $currentPage === 'projects.php' ? 'active' : '' ?>">Projects</a></li>
                    <li><a href="services.php" class="<?= $currentPage === 'services.php' ? 'active' : '' ?>">Services</a></li>
          <li><a href="./contactus.php" class="<?= $currentPage === 'contactus.php' ? 'active' : '' ?>">Contact Us</a></li>

        </ul>
      </nav>
    </div>
  </header>

  <!-- HERO -->
  <section class="hero">
    <div class="hero-inner container">
      <div class="hero-content">
        <span class="hero-kicker">Trusted Construction Partner</span>
        <h1>Concept to Completion for Refined Construction & Interiors</h1>
        <p>First Choice delivers premium villa construction, maintenance, fit-outs, steel fabrication, MEP works, and bespoke carpentry with disciplined execution and on-time delivery.</p>
        <div class="hero-actions">
          <a class="hero-cta" href="./contactus.php">Start a Project</a>
          <a class="hero-ghost" href="./projects.php">View Projects</a>
        </div>
        <div class="hero-meta">
          <div class="hero-stat">
            <strong>20+ Years</strong>
            <span>Regional expertise in UAE and Oman</span>
          </div>
          <div class="hero-stat">
            <strong>Quality First</strong>
            <span>Premium materials, certified workmanship</span>
          </div>
          <div class="hero-stat">
            <strong>On-Time</strong>
            <span>Clear timelines and reliable delivery</span>
          </div>
        </div>
      </div>
      <div class="hero-card">
        <h4>Core Capabilities</h4>
        <ul>
          <li><i class="fa-solid fa-check"></i> New villa construction and structural delivery</li>
          <li><i class="fa-solid fa-check"></i> Interior design, fit-out, and joinery solutions</li>
          <li><i class="fa-solid fa-check"></i> Steel fabrication, MEP works, and maintenance</li>
          <li><i class="fa-solid fa-check"></i> Dedicated supervision and quality assurance</li>
        </ul>
      </div>
    </div>
  </section>








<?php
include 'config.php';
?>

<!-- SERVICES -->
<section class="section-light">
  <div class="container">
    <div class="section-title">
      <h2>Our Professional Services</h2>
      <p>Reliable construction and décor solutions delivered with quality, safety, and expertise</p>
    </div>

   
<div class="services">
  <?php
$services = $conn->query("SELECT * FROM services ORDER BY id DESC LIMIT 3");

  while($row = $services->fetch_assoc()){
  ?>
  
  <div class="service-card">
<div class="service-icon"><i class="<?php echo $row['icon']; ?>"></i></div>
    <h3><?php echo $row['title']; ?></h3>
    <p><?php echo $row['description']; ?></p>

   <ul class="service-features">
<?php
$sid = (int)$row['id'];
$features = $conn->query("SELECT feature FROM service_features WHERE service_id = $sid LIMIT 4");

if($features && $features->num_rows > 0){
  $count = 0;
  while($f = $features->fetch_assoc()){
    if($count < 4) {
      echo "<li>✓ ".$f['feature']."</li>";
    }
    $count++;
  }
} else {
  echo "<li>✓ Professional expertise</li>";
  echo "<li>✓ Quality assurance</li>";
  echo "<li>✓ On-time delivery</li>";
  echo "<li>✓ Client satisfaction</li>";
}
?>
</ul>

    <a href="./services.php">Explore Service</a>
  </div>

  <?php } ?>
</div>

    <!-- button -->
    <div class="cta-right">
      <a href="./services.php" class="about-btn">
        <i class="fa-solid fa-arrow-right"></i>
      </a>
    </div>  
  </div>
</section>
















<!-- ABOUT US -->
<section id="about" style="background-color: #ffffff;">
  <div class="container about-layout">
    
    <!-- IMAGE -->
    <div class="about-img-col">
      <img src="./assests/images/New Pact Construction Llc.jpg" 
           alt="About Us" 
           class="about-img">
    </div>
    
    <!-- TEXT CONTENT -->
    <div class="about-text-col">
      <h2 style="font-size:36px; color:#1a1a1a; margin-bottom:20px; font-weight: 700;">About Us</h2>
      <p style="font-size:16px; color:#555; margin-bottom:20px; line-height:1.8;">
        First Choice is a group of companies which is providing service to Industrial is, commercial and residential sectors in a high quality standard using the latest value engineering processes.

First Choice is a geographical expansion of the company operations in Oman. First Choice was established in August, 2004 in Abu Dhabi - UAE to cater the booming and demanding market in UAE specifically the Emirate of Abu Dhabi.

      <!-- HIGHLIGHTS -->
      <div class="highlights-grid">
        <div class="highlight-card">
          <h3 style="color:#2d7a5c;">20+</h3>
          <p>Years Experience</p>
        </div>

        <div class="highlight-card">
          <h3 style="color:#d4af37;">500+</h3>
          <p>Projects Completed</p>
        </div>

        <div class="highlight-card">
          <h3 style="color:#2d7a5c;">100%</h3>
          <p>Client Satisfaction</p>
        </div>

        <div class="highlight-card">
          <h3 style="color:#d4af37;">50+</h3>
          <p>Expert Professionals</p>
        </div>
      </div>

      <!-- BUTTON -->
      <div style="margin-top:30px;">
        <a href="./aboutus.php" class="about-btn">Explore More <i class="fa-solid fa-arrow-right"></i></a>
      </div>
    </div>
    
  </div>
</section>










<!-- OUR CERTIFICATIONS -->
<section class="certifications" id="certifications">
  <div class="cert-container">
    <h2 class="cert-title">Our Certifications</h2>
    <p class="cert-subtitle">
      We are officially certified to deliver quality civil construction and professional interior & décor works.
    </p>

    <div class="cert-grid">

<?php
$certs = $conn->query("SELECT * FROM certifications ORDER BY id DESC LIMIT 4");
while($row = $certs->fetch_assoc()){
  $imagePath = $row['image'] ?? '';
  $imagePath = basename(str_replace(['../', '..\\'], '', $imagePath));
  $imageUrl = '';
  if (!empty($imagePath)) {
    $imageUrl = '/firstchoice_admin/files/' . $imagePath;
  }
?>
  <div class="cert-card" onclick="openCert('<?php echo $imagePath; ?>')">
    <?php if (!empty($imageUrl)): ?>
      <img src="<?php echo $imageUrl; ?>" alt="<?php echo htmlspecialchars($row['title']); ?>" onerror="this.onerror=null;this.src='/firstchoice_admin/admin/files/<?php echo htmlspecialchars($imagePath); ?>';">
    <?php endif; ?>
    <h3><?php echo htmlspecialchars($row['title']); ?></h3>
  </div>
<?php } ?>

</div>
  <!-- button -->
  <div class="cta-right">
    <a href="./certification.php" class="about-btn">
      <i class="fa-solid fa-arrow-right"></i>
    </a>
  </div>  
</section>

<!-- Modal -->
<div class="cert-modal" id="certModal">
  <span class="close" onclick="closeCert()">&times;</span>
  <img id="certImage">
</div>











<!-- OUR TEAM -->
<section id="team" style="background-color: #ffffff;">
  <div class="container">

    <!-- SECTION TITLE -->
    <div class="section-title">
      <h2>Meet Our Team</h2>
      <p>
        Our expert team of professionals brings experience, creativity, and dedication to every project.
      </p>
    </div>

    <!-- TEAM CARDS -->
    <div class="team-members">

      <?php
$team = $conn->query("SELECT * FROM team ORDER BY id DESC LIMIT 3");

      if($team->num_rows > 0){
        while($row = $team->fetch_assoc()){
      ?>

      <div class="team-card">
        <img src="<?php echo str_replace('../', '', $row['photo']); ?>" 
             alt="<?php echo $row['name']; ?>">

        <div class="team-info">
          <h3><?php echo $row['name']; ?></h3>
          <?php if (!empty($row['role'] ?? '')): ?>
            <p><?php echo htmlspecialchars($row['role']); ?></p>
          <?php endif; ?>
          <div class="team-bio"><?php echo htmlspecialchars($row['bio'] ?? ''); ?></div>

          <div class="team-contact">
            <div>
              <i class="fas fa-phone"></i>
              <span><?php echo $row['phone']; ?></span>
            </div>
            <div>
              <i class="fas fa-envelope"></i>
              <span><?php echo $row['email']; ?></span>
            </div>
          </div>
        </div>
      </div>

      <?php
        }
      } else {
        echo "<p>No team members found</p>";
      }
      ?>

    </div>

    <!-- BUTTON -->
    <div class="cta-right">
      <a href="./team.php" class="about-btn" style="margin-right: 15px;">
        View All Team <i class="fa-solid fa-arrow-right"></i>
      </a>
    </div>  

  </div>
</section>





















<!-- OUR PROJECTS -->
<section class="projects-section premium-projects" style="background: #ffffff;">
  <div class="container">

    <div class="projects-hero">
      <h2>Our Projects</h2>
      <p>High-impact civil construction and refined décor projects. Built for longevity, delivered with precision.</p>
    </div>

    <div class="projects-block">
      <div class="projects-block-head">
        <div class="block-pill civil">Civil Projects</div>
        <div class="block-desc">Infrastructure, foundations, and structural delivery at scale.</div>
      </div>

      <div class="projects-grid">
        <?php
        $civil = $conn->query("SELECT * FROM projects WHERE type='Civil' AND (status=1 OR status='completed') ORDER BY id DESC LIMIT 3");
        while($row = $civil->fetch_assoc()):
          $galleryImages = [];
          if (!empty($row['image'])) {
            $galleryImages[] = '/firstchoice_admin/' . ltrim(str_replace(['../', '..\\'], '', $row['image']), '/');
          }
          $hasProjectImages = $conn->query("SHOW TABLES LIKE 'project_images'");
          if ($hasProjectImages && $hasProjectImages->num_rows > 0) {
            $gRes = $conn->query("SELECT image FROM project_images WHERE project_id=".(int)$row['id']." ORDER BY id ASC");
            if ($gRes && $gRes->num_rows > 0) {
              while ($g = $gRes->fetch_assoc()) {
                if (!empty($g['image'])) {
                  $galleryImages[] = '/firstchoice_admin/' . ltrim(str_replace(['../', '..\\'], '', $g['image']), '/');
                }
              }
            }
          }
          $galleryImages = array_values(array_unique($galleryImages));
          $galleryCsv = htmlspecialchars(implode('|', $galleryImages), ENT_QUOTES);
        ?>
        <article class="project-card premium">
          <div class="project-media" onclick="openProjectGallery('<?php echo $galleryCsv; ?>')">
            <img src="<?= ltrim(str_replace('../', '', $row['image'] ?? ''), '/') ?>" alt="<?= $row['title'] ?>">
            <span class="project-badge civil">Civil Works</span>
            <?php if (!empty($galleryImages) && count($galleryImages) > 1): ?>
              <span class="project-count"><?= count($galleryImages) ?> Photos</span>
            <?php endif; ?>
          </div>
          <div class="project-body">
            <h3><?= $row['title'] ?></h3>
            <p><?= $row['description'] ?></p>
            <a class="project-link" href="./projects.php#civil">View Details <i class="fas fa-arrow-right"></i></a>
          </div>
        </article>
        <?php endwhile; ?>
      </div>
    </div>

    <div class="projects-block">
      <div class="projects-block-head">
        <div class="block-pill decor">Decor Works</div>
        <div class="block-desc">Interior and exterior finishes with elevated craftsmanship.</div>
      </div>

      <div class="projects-grid">
        <?php
        $decor = $conn->query("SELECT * FROM projects WHERE type='Decor' AND (status=1 OR status='completed') ORDER BY id DESC LIMIT 3");
        while($row = $decor->fetch_assoc()):
          $galleryImages = [];
          if (!empty($row['image'])) {
            $galleryImages[] = '/firstchoice_admin/' . ltrim(str_replace(['../', '..\\'], '', $row['image']), '/');
          }
          $hasProjectImages = $conn->query("SHOW TABLES LIKE 'project_images'");
          if ($hasProjectImages && $hasProjectImages->num_rows > 0) {
            $gRes = $conn->query("SELECT image FROM project_images WHERE project_id=".(int)$row['id']." ORDER BY id ASC");
            if ($gRes && $gRes->num_rows > 0) {
              while ($g = $gRes->fetch_assoc()) {
                if (!empty($g['image'])) {
                  $galleryImages[] = '/firstchoice_admin/' . ltrim(str_replace(['../', '..\\'], '', $g['image']), '/');
                }
              }
            }
          }
          $galleryImages = array_values(array_unique($galleryImages));
          $galleryCsv = htmlspecialchars(implode('|', $galleryImages), ENT_QUOTES);
        ?>
        <article class="project-card premium">
          <div class="project-media" onclick="openProjectGallery('<?php echo $galleryCsv; ?>')">
            <img src="<?= ltrim(str_replace('../', '', $row['image'] ?? ''), '/') ?>" alt="<?= $row['title'] ?>">
            <span class="project-badge decor">Décor Works</span>
            <?php if (!empty($galleryImages) && count($galleryImages) > 1): ?>
              <span class="project-count"><?= count($galleryImages) ?> Photos</span>
            <?php endif; ?>
          </div>
          <div class="project-body">
            <h3><?= $row['title'] ?></h3>
            <p><?= $row['description'] ?></p>
            <a class="project-link decor" href="./projects.php#decor">View Details <i class="fas fa-arrow-right"></i></a>
          </div>
        </article>
        <?php endwhile; ?>
      </div>
    </div>

    <div class="projects-cta">
      <a href="./projects.php" class="about-btn">View All Projects <i class="fa-solid fa-arrow-right"></i></a>
    </div>

  </div>
</section>


<!-- Project Gallery Modal -->
<div class="project-gallery-modal" id="projectGalleryModal">
  <div class="project-gallery-card">
    <img id="projectGalleryMain" alt="Project Image">
    <div class="project-gallery-thumbs" id="projectGalleryThumbs"></div>
  </div>
  <span class="close" onclick="closeProjectGallery()">&times;</span>
</div>

<!-- CONTACT US PAGE -->
<section id="contact" style="background: #ffffff;">
  <div class="container">

    <!-- SECTION TITLE -->








    <div class="section-title">
      <h2>Contact Us</h2>
      <p>
        Have questions or want to discuss a project? Get in touch with our professional team.
      </p>
    </div>

    <!-- CONTACT CONTENT -->





    <div class="contact-layout">

      <div class="contact-form-card contact-form-area">
              <?php if (isset($_GET['sent']) && $_GET['sent'] === '1'): ?>          <div class="alert-msg success">
            Message sent successfully! We will contact you soon.
          </div>
        <?php endif; ?>
        <form method="POST" action="contactus.php">
          <input type="hidden" name="return_to" value="index.php">
          <input type="text" name="name" placeholder="Your Name" required>
          <input type="email" name="email" placeholder="Your Email" required>
          <input type="text" name="phone" placeholder="Phone (optional)">
          <input type="text" name="subject" placeholder="Subject">
          <textarea rows="6" name="message" placeholder="Your Message" required></textarea>
          <button type="submit">Send Message</button>
        </form>
      </div>

      <div class="contact-info-card contact-info-area">
        <h3>Get in Touch</h3>
        <p>We are here to answer your questions and provide solutions for your projects.</p>

        <div class="contact-item">
          <span>📍</span>
          <p>Musaffah - MW4 - Abu Dhabi - United Arab Emirates</p>
        </div>

        <div class="contact-item">
          <span>📞</span>
          <p>+971 2 557 1642 , +971 55 315 9291</p>
        </div>

        <div class="contact-item">
          <span>✉️</span>
          <p>firstchoice.rgc@gmail.com</p>
        </div>

        <div class="contact-item">
          <span>⏰</span>
          <p>Mon - Sat: 9:00 AM - 6:00 PM</p>
        </div>
      </div>

    </div>
  </div>
</section>




  <!-- FOOTER -->
  <footer>
    <p>
      First Choice Group of Companies <br>
      First Choice Real General Contracting and Maintenance LLC OPC (FCRGC) <br>
      First Choice Automotive Parts Cars Sole Proprietorship LLC (FCAPC) <br>
      <br>
      © 2024-2025
    </p>
  </footer>

<script src="./script.js"></script>

  <script src="assests/site.js"></script>
  <script>
    // Certification Modal Script
    function openCert(imgSrc) {
      const modal = document.getElementById('certModal');
      const modalImg = document.getElementById('certImage');
      modal.style.display = 'block';
      if (!imgSrc) return;
      if (imgSrc.indexOf('/') === -1) {
        modalImg.src = '/firstchoice_admin/files/' + imgSrc;
        modalImg.onerror = function() {
          this.onerror = null;
          this.src = '/firstchoice_admin/admin/files/' + imgSrc;
        };
      } else {
        modalImg.src = imgSrc;
      }
    }

    function closeCert() {
      const modal = document.getElementById('certModal');
      modal.style.display = 'none';
    }

    // Project Gallery Modal Script
    function openProjectGallery(imagesCsv) {
      if (!imagesCsv) return;
      var images = imagesCsv.split('|').filter(Boolean);
      if (images.length === 0) return;
      var modal = document.getElementById('projectGalleryModal');
      var main = document.getElementById('projectGalleryMain');
      var thumbs = document.getElementById('projectGalleryThumbs');
      thumbs.innerHTML = '';
      main.src = images[0];
      images.forEach(function(src, idx) {
        var img = document.createElement('img');
        img.src = src;
        if (idx === 0) img.classList.add('active');
        img.onclick = function() {
          main.src = src;
          document.querySelectorAll('.project-gallery-thumbs img').forEach(function(t){ t.classList.remove('active'); });
          img.classList.add('active');
        };
        thumbs.appendChild(img);
      });
      modal.style.display = 'flex';
      modal.style.alignItems = 'center';
      modal.style.justifyContent = 'center';
    }

    function closeProjectGallery() {
      var modal = document.getElementById('projectGalleryModal');
      modal.style.display = 'none';
    }

    // Close modals when clicking outside
    document.addEventListener('click', function(e) {
      var certModal = document.getElementById('certModal');
      if (e.target === certModal) {
        certModal.style.display = 'none';
      }
      
      var projModal = document.getElementById('projectGalleryModal');
      if (e.target === projModal) {
        projModal.style.display = 'none';
      }
    });

    // Close on Escape key
    document.addEventListener('keydown', function(e) {
      if (e.key === 'Escape') {
        document.getElementById('certModal').style.display = 'none';
        document.getElementById('projectGalleryModal').style.display = 'none';
      }
    });
  </script>
</body>

</html>
