<?php
include 'config.php';
$currentPage = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Projects | First Choice Real Estate</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
<link rel="stylesheet" href="assests/style.css">
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

</head>
<body>

  <!-- HEADER -->
  <header>
    <div class="navbar">
      <a class="logo" href="./index.php"><img src="assests/images/headlogo.png" alt="First Choice"></a>
      <button class="nav-toggle" aria-label="Toggle navigation" aria-expanded="false">
        <span></span>
      </button>
      <nav class="nav">
        <ul>
         <li><a href="./index.php" class="<?= $currentPage === 'index.php' ? 'active' : '' ?>">Home</a></li>
          <li><a href="./aboutus.php" class="<?= $currentPage === 'aboutus.php' ? 'active' : '' ?>">About Us</a></li>
          <li><a href="./certification.php" class="<?= $currentPage === 'certification.php' ? 'active' : '' ?>">Certification</a></li>
          <li><a href="./team.php" class="<?= $currentPage === 'team.php' ? 'active' : '' ?>">Team</a></li>
          <li><a href="./projects.php" class="<?= $currentPage === 'projects.php' ? 'active' : '' ?>">Projects</a></li>
                    <li><a href="./services.php" class="<?= $currentPage === 'services.php' ? 'active' : '' ?>">Services</a></li>
          <li><a href="./contactus.php" class="<?= $currentPage === 'contactus.php' ? 'active' : '' ?>">Contact Us</a></li>

        </ul>
      </nav>
    </div>
  </header>
  <!-- HERO -->
  <section class="hero">
    <div class="hero-inner container">
      <div class="hero-content">
        <span class="hero-kicker">Featured Projects</span>
        <h1>Built to Last. Delivered with Precision.</h1>
        <p>Explore a portfolio of civil construction and refined decor projects executed with rigorous standards, quality materials, and on-time delivery.</p>
        <div class="hero-actions">
          <a class="hero-cta" href="./contactus.php">Start a Project</a>
          <a class="hero-ghost" href="./services.php">View Services</a>
        </div>
        <div class="hero-meta">
          <div class="hero-stat">
            <strong>Civil Works</strong>
            <span>Infrastructure and structural delivery</span>
          </div>
          <div class="hero-stat">
            <strong>Decor Works</strong>
            <span>Interior and exterior craftsmanship</span>
          </div>
          <div class="hero-stat">
            <strong>On-Time</strong>
            <span>Clear timelines and reliable execution</span>
          </div>
        </div>
      </div>
      <div class="hero-card">
        <h4>Project Standards</h4>
        <ul>
          <li><i class="fa-solid fa-check"></i> Structured planning and site supervision</li>
          <li><i class="fa-solid fa-check"></i> Quality-controlled materials and finishes</li>
          <li><i class="fa-solid fa-check"></i> Safety-first execution and compliance</li>
          <li><i class="fa-solid fa-check"></i> Transparent reporting at every stage</li>
        </ul>
      </div>
    </div>
  </section>

  
<!-- OUR PROJECTS -->
<section class="projects-section premium-projects">
  <div class="container">

    <div class="projects-hero">
      <h2>Our Projects</h2>
      <p>High-impact civil construction and refined décor projects. Built for longevity, delivered with precision.</p>
    </div>

    <div class="projects-block" id="civil">
      <div class="projects-block-head">
        <div class="block-pill civil">Civil Projects</div>
        <div class="block-desc">Infrastructure, foundations, and structural delivery at scale.</div>
      </div>

      <div class="projects-grid">
        <?php
        $civil = $conn->query("SELECT * FROM projects WHERE type='Civil' AND (status=1 OR status='completed') ORDER BY id DESC");
        while($row = $civil->fetch_assoc()):
          $galleryImages = [];
          if (!empty($row['image'])) {
            $galleryImages[] = '/firstchoice_admin/' . ltrim($row['image'], '/');
          }
          $hasProjectImages = $conn->query("SHOW TABLES LIKE 'project_images'");
          if ($hasProjectImages && $hasProjectImages->num_rows > 0) {
            $gRes = $conn->query("SELECT image FROM project_images WHERE project_id=".(int)$row['id']." ORDER BY id ASC");
            if ($gRes && $gRes->num_rows > 0) {
              while ($g = $gRes->fetch_assoc()) {
                if (!empty($g['image'])) {
                  $galleryImages[] = '/firstchoice_admin/' . ltrim($g['image'], '/');
                }
              }
            }
          }
          $galleryImages = array_values(array_unique($galleryImages));
          $galleryCsv = htmlspecialchars(implode('|', $galleryImages), ENT_QUOTES);
        ?>
        <article class="project-card premium">
          <div class="project-media" onclick="openProjectGallery('<?php echo $galleryCsv; ?>')">
            <img src="<?= ltrim(str_replace('../', '', $row['image'] ?? ''), '/') ?>" alt="<?= $row['title'] ?>">
            <span class="project-badge civil">Civil Works</span>
            <?php if (!empty($galleryImages) && count($galleryImages) > 1): ?>
              <span class="project-count"><?= count($galleryImages) ?> Photos</span>
            <?php endif; ?>
          </div>
          <div class="project-body">
            <h3><?= $row['title'] ?></h3>
            <p><?= $row['description'] ?></p>
          </div>
        </article>
        <?php endwhile; ?>
      </div>
    </div>

    <div class="projects-block" id="decor">
      <div class="projects-block-head">
        <div class="block-pill decor">Decor Works</div>
        <div class="block-desc">Interior and exterior finishes with elevated craftsmanship.</div>
      </div>

      <div class="projects-grid">
        <?php
        $decor = $conn->query("SELECT * FROM projects WHERE type='Decor' AND (status=1 OR status='completed') ORDER BY id DESC");
        while($row = $decor->fetch_assoc()):
          $galleryImages = [];
          if (!empty($row['image'])) {
            $galleryImages[] = '/firstchoice_admin/' . ltrim($row['image'], '/');
          }
          $hasProjectImages = $conn->query("SHOW TABLES LIKE 'project_images'");
          if ($hasProjectImages && $hasProjectImages->num_rows > 0) {
            $gRes = $conn->query("SELECT image FROM project_images WHERE project_id=".(int)$row['id']." ORDER BY id ASC");
            if ($gRes && $gRes->num_rows > 0) {
              while ($g = $gRes->fetch_assoc()) {
                if (!empty($g['image'])) {
                  $galleryImages[] = '/firstchoice_admin/' . ltrim($g['image'], '/');
                }
              }
            }
          }
          $galleryImages = array_values(array_unique($galleryImages));
          $galleryCsv = htmlspecialchars(implode('|', $galleryImages), ENT_QUOTES);
        ?>
        <article class="project-card premium">
          <div class="project-media" onclick="openProjectGallery('<?php echo $galleryCsv; ?>')">
            <img src="<?= ltrim(str_replace('../', '', $row['image'] ?? ''), '/') ?>" alt="<?= $row['title'] ?>">
            <span class="project-badge decor">Décor Works</span>
            <?php if (!empty($galleryImages) && count($galleryImages) > 1): ?>
              <span class="project-count"><?= count($galleryImages) ?> Photos</span>
            <?php endif; ?>
          </div>
          <div class="project-body">
            <h3><?= $row['title'] ?></h3>
            <p><?= $row['description'] ?></p>
          </div>
        </article>
        <?php endwhile; ?>
      </div>
    </div>

  </div>
</section>

<!-- Project Gallery Modal -->
<div class="project-gallery-modal" id="projectGalleryModal">
  <div class="project-gallery-card">
    <img id="projectGalleryMain" alt="Project Image">
    <div class="project-gallery-thumbs" id="projectGalleryThumbs"></div>
    
  </div>
  <span class="close" onclick="closeProjectGallery()">&times;</span>
</div>

<script>
function openProjectGallery(imagesCsv) {
  if (!imagesCsv) return;
  var images = imagesCsv.split('|').filter(Boolean);
  if (images.length === 0) return;
  var modal = document.getElementById('projectGalleryModal');
  var main = document.getElementById('projectGalleryMain');
  var thumbs = document.getElementById('projectGalleryThumbs');
  thumbs.innerHTML = '';
  main.src = images[0];
  images.forEach(function(src, idx) {
    var img = document.createElement('img');
    img.src = src;
    if (idx === 0) img.classList.add('active');
    img.onclick = function() {
      main.src = src;
      document.querySelectorAll('.project-gallery-thumbs img').forEach(function(t){ t.classList.remove('active'); });
      img.classList.add('active');
    };
    thumbs.appendChild(img);
  });
  modal.style.display = 'flex';
  modal.style.alignItems = 'center';
  modal.style.justifyContent = 'center';
}

function closeProjectGallery() {
  var modal = document.getElementById('projectGalleryModal');
  modal.style.display = 'none';
}

document.addEventListener('click', function(e) {
  var modal = document.getElementById('projectGalleryModal');
  if (e.target === modal) {
    modal.style.display = 'none';
  }
});
</script>
<!-- FOOTER -->
  <footer>
    <p>
      First Choice Group of Companies <br>
      First Choice Real General Contracting and Maintenance LLC OPC (FCRGC) <br>
      First Choice Automotive Parts Cars Sole Proprietorship LLC (FCAPC) <br>
      <br>
      © 2024-2025
    </p>
  </footer>

<script src="./script.js"></script>



  <script src="assests/site.js"></script>
</body>
</html>
