<?php
include 'config.php';
$currentPage = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Services | First Choice Real Estate</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
  <link rel="stylesheet" href="assests/style.css">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>

  <!-- HEADER -->
  <header>
    <div class="navbar">
      <a class="logo" href="./index.php"><img src="assests/images/headlogo.png" alt="First Choice"></a>
      <button class="nav-toggle" aria-label="Toggle navigation" aria-expanded="false">
        <span></span>
      </button>
      <nav class="nav">
        <ul>
          <li><a href="./index.php" class="<?= $currentPage === 'index.php' ? 'active' : '' ?>">Home</a></li>
          <li><a href="./aboutus.php" class="<?= $currentPage === 'aboutus.php' ? 'active' : '' ?>">About Us</a></li>
          <li><a href="./certification.php" class="<?= $currentPage === 'certification.php' ? 'active' : '' ?>">Certification</a></li>
          <li><a href="./team.php" class="<?= $currentPage === 'team.php' ? 'active' : '' ?>">Team</a></li>
          <li><a href="./projects.php" class="<?= $currentPage === 'projects.php' ? 'active' : '' ?>">Projects</a></li>
          <li><a href="./services.php" class="<?= $currentPage === 'services.php' ? 'active' : '' ?>">Services</a></li>
          <li><a href="./contactus.php" class="<?= $currentPage === 'contactus.php' ? 'active' : '' ?>">Contact Us</a></li>
        </ul>
      </nav>
    </div>
  </header>
  <!-- HERO -->
  <section class="hero">
    <div class="hero-inner container">
      <div class="hero-content">
        <span class="hero-kicker">Our Services</span>
        <h1>End-to-End Solutions for Construction & Interiors</h1>
        <p>From new villa construction to decor, maintenance, MEP works, and steel fabrication, we deliver integrated services with disciplined quality and clear timelines.</p>
        <div class="hero-actions">
          <a class="hero-cta" href="./contactus.php">Request a Quote</a>
          <a class="hero-ghost" href="./projects.php">View Projects</a>
        </div>
        <div class="hero-meta">
          <div class="hero-stat">
            <strong>Civil &amp; Decor</strong>
            <span>Construction, fit-out, and joinery</span>
          </div>
          <div class="hero-stat">
            <strong>MEP &amp; Steel</strong>
            <span>Fabrication, maintenance, and systems</span>
          </div>
          <div class="hero-stat">
            <strong>Quality First</strong>
            <span>Certified teams and tested materials</span>
          </div>
        </div>
      </div>
      <div class="hero-card">
        <h4>Service Promise</h4>
        <ul>
          <li><i class="fa-solid fa-check"></i> Structured planning and scope clarity</li>
          <li><i class="fa-solid fa-check"></i> Skilled crews with on-site supervision</li>
          <li><i class="fa-solid fa-check"></i> Safety-compliant processes and audits</li>
          <li><i class="fa-solid fa-check"></i> Reliable delivery from concept to completion</li>
        </ul>
      </div>
    </div>
  </section>

  <!-- SERVICES -->
  <section class="section-light">
    <div class="container">
      <div class="section-title">
        <h2>Our Professional Services</h2>
        <p>Reliable construction and décor solutions delivered with quality, safety, and expertise</p>
      </div>

      <div class="services">
        <?php
        $services = $conn->query("SELECT * FROM services ORDER BY id DESC");
        while($row = $services->fetch_assoc()){
        ?>
        <div class="service-card">
          <div class="service-icon"><i class="<?php echo $row['icon']; ?>"></i></div>
          <h3><?php echo $row['title']; ?></h3>
          <p><?php echo $row['description']; ?></p>

          <ul class="service-features">
            <?php
            $sid = (int)$row['id'];
            $features = $conn->query("SELECT feature FROM service_features WHERE service_id = $sid LIMIT 4");
            if($features && $features->num_rows > 0){
              $count = 0;
              while($f = $features->fetch_assoc()){
                if($count < 4) {
                  echo "<li>✓ ".$f['feature']."</li>";
                }
                $count++;
              }
            } else {
              echo "<li>✓ Professional expertise</li>";
              echo "<li>✓ Quality assurance</li>";
              echo "<li>✓ On-time delivery</li>";
              echo "<li>✓ Client satisfaction</li>";
            }
            ?>
          </ul>
        </div>
        <?php } ?>
      </div>
    </div>
  </section>

  <!-- FOOTER -->
  <footer>
    <p>
      First Choice Group of Companies <br>
      First Choice Real General Contracting and Maintenance LLC OPC (FCRGC) <br>
      First Choice Automotive Parts Cars Sole Proprietorship LLC (FCAPC) <br>
      <br>
      © 2024-2025
    </p>
  </footer>

  <script src="./script.js"></script>
  <script src="assests/site.js"></script>
</body>
</html>
