

<?php
include 'config.php';
$currentPage = basename($_SERVER['PHP_SELF']);

// Fetch active team members
$result = $conn->query("SELECT * FROM team WHERE status=1 ORDER BY id DESC");
?>






<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Team | First Choice Real Estate</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
<link rel="stylesheet" href="assests/style.css">
  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

</head>
<body> 
 <!-- HEADER -->
  <header>
    <div class="navbar">
      <a class="logo" href="./index.php"><img src="assests/images/headlogo.png" alt="First Choice"></a>
      <button class="nav-toggle" aria-label="Toggle navigation" aria-expanded="false">
        <span></span>
      </button>
      <nav class="nav">
        <ul>
           <li><a href="./index.php" class="<?= $currentPage === 'index.php' ? 'active' : '' ?>">Home</a></li>
          <li><a href="./aboutus.php" class="<?= $currentPage === 'aboutus.php' ? 'active' : '' ?>">About Us</a></li>
          <li><a href="./certification.php" class="<?= $currentPage === 'certification.php' ? 'active' : '' ?>">Certification</a></li>
          <li><a href="./team.php" class="<?= $currentPage === 'team.php' ? 'active' : '' ?>">Team</a></li>
          <li><a href="./projects.php" class="<?= $currentPage === 'projects.php' ? 'active' : '' ?>">Projects</a></li>
                    <li><a href="./services.php" class="<?= $currentPage === 'services.php' ? 'active' : '' ?>">Services</a></li>
          <li><a href="./contactus.php" class="<?= $currentPage === 'contactus.php' ? 'active' : '' ?>">Contact Us</a></li>

        </ul>
      </nav>
    </div>
  </header>
  <!-- HERO -->
  <section class="hero">
    <div class="hero-inner container">
      <div class="hero-content">
        <span class="hero-kicker">Our Team</span>
        <h1>Crafted by Experts. Delivered with Care.</h1>
        <p>Our multidisciplinary team brings hands-on experience across civil construction, interiors, steel fabrication, MEP works, and maintenance to deliver consistent, high-quality outcomes.</p>
        <div class="hero-actions">
          <a class="hero-cta" href="./contactus.php">Meet the Team</a>
          <a class="hero-ghost" href="./projects.php">View Projects</a>
        </div>
        <div class="hero-meta">
          <div class="hero-stat">
            <strong>Specialists</strong>
            <span>Cross-discipline expertise on every site</span>
          </div>
          <div class="hero-stat">
            <strong>Certified</strong>
            <span>Safety-led, quality-first execution</span>
          </div>
          <div class="hero-stat">
            <strong>Dedicated</strong>
            <span>Client-focused communication and support</span>
          </div>
        </div>
      </div>
      <div class="hero-card">
        <h4>Team Strengths</h4>
        <ul>
          <li><i class="fa-solid fa-check"></i> Project managers with on-site leadership</li>
          <li><i class="fa-solid fa-check"></i> Skilled technicians for civil and decor work</li>
          <li><i class="fa-solid fa-check"></i> MEP coordination with safety compliance</li>
          <li><i class="fa-solid fa-check"></i> Reliable delivery from concept to completion</li>
        </ul>
      </div>
    </div>
  </section>

  



  <!-- OUR TEAM -->
<section class="section-light">
  <div class="container">

    <!-- SECTION TITLE -->
    <div class="section-title">
      <h2>Meet Our Team</h2>
      <p>
        Our expert team of professionals brings experience, creativity, and dedication to every project.
      </p>
    </div>

    <!-- TEAM CARDS -->
    <div class="team-members">

      <?php
      $team = $conn->query("SELECT * FROM team ORDER BY id DESC");

      if($team->num_rows > 0){
        while($row = $team->fetch_assoc()){
      ?>

      <div class="team-card">
        <img src="<?php echo str_replace('../', '', $row['photo']); ?>" 
             alt="<?php echo $row['name']; ?>">

        <div class="team-info">
          <h3><?php echo $row['name']; ?></h3>
          <?php if (!empty($row['role'] ?? '')): ?>
            <p><?php echo htmlspecialchars($row['role']); ?></p>
          <?php endif; ?>
          <div class="team-bio"><?php echo htmlspecialchars($row['bio'] ?? ''); ?></div>

          <div class="team-contact">
            <div>
              <i class="fas fa-phone"></i>
              <span><?php echo $row['phone']; ?></span>
            </div>
            <div>
              <i class="fas fa-envelope"></i>
              <span><?php echo $row['email']; ?></span>
            </div>
          </div>
        </div>
      </div>

      <?php
        }
      } else {
        echo "<p>No team members found</p>";
      }
      ?>

    </div>

   

  </div>
</section>

<!-- FOOTER -->
  <footer>
    <p>
      First Choice Group of Companies <br>
      First Choice Real General Contracting and Maintenance LLC OPC (FCRGC) <br>
      First Choice Automotive Parts Cars Sole Proprietorship LLC (FCAPC) <br>
      <br>
      © 2024-2025
    </p>
  </footer>





<script src="./script.js"></script>



  <script src="assests/site.js"></script>
</body>
</html>
